import { ExceptionOptionType as __ExceptionOptionType } from "@smithy/smithy-client";
import { CognitoIdentityProviderServiceException as __BaseException } from "./CognitoIdentityProviderServiceException";
import {
  AccountRecoverySettingType,
  AccountTakeoverRiskConfigurationType,
  AdminCreateUserConfigType,
  AnalyticsConfigurationType,
  AnalyticsMetadataType,
  AttributeType,
  CodeDeliveryDetailsType,
  CompromisedCredentialsRiskConfigurationType,
  CustomDomainConfigType,
  DeletionProtectionType,
  DeviceConfigurationType,
  DeviceRememberedStatusType,
  EmailConfigurationType,
  ExplicitAuthFlowsType,
  FeedbackValueType,
  GroupType,
  IdentityProviderType,
  LambdaConfigType,
  LogConfigurationType,
  LogDeliveryConfigurationType,
  MFAOptionType,
  OAuthFlowType,
  PreventUserExistenceErrorTypes,
  ResourceServerScopeType,
  ResourceServerType,
  RiskConfigurationType,
  RiskExceptionConfigurationType,
  SmsConfigurationType,
  SmsMfaConfigType,
  SMSMfaSettingsType,
  SoftwareTokenMfaConfigType,
  SoftwareTokenMfaSettingsType,
  TokenValidityUnitsType,
  UICustomizationType,
  UserAttributeUpdateSettingsType,
  UserContextDataType,
  UserImportJobType,
  UserPoolAddOnsType,
  UserPoolClientType,
  UserPoolMfaType,
  UserPoolPolicyType,
  VerificationMessageTemplateType,
  VerifiedAttributeType,
} from "./models_0";
export interface RevokeTokenResponse {}
export declare class UnauthorizedException extends __BaseException {
  readonly name: "UnauthorizedException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<UnauthorizedException, __BaseException>
  );
}
export declare class UnsupportedOperationException extends __BaseException {
  readonly name: "UnsupportedOperationException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<UnsupportedOperationException, __BaseException>
  );
}
export declare class UnsupportedTokenTypeException extends __BaseException {
  readonly name: "UnsupportedTokenTypeException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<UnsupportedTokenTypeException, __BaseException>
  );
}
export interface SetLogDeliveryConfigurationRequest {
  UserPoolId: string | undefined;
  LogConfigurations: LogConfigurationType[] | undefined;
}
export interface SetLogDeliveryConfigurationResponse {
  LogDeliveryConfiguration?: LogDeliveryConfigurationType;
}
export interface SetRiskConfigurationRequest {
  UserPoolId: string | undefined;
  ClientId?: string;
  CompromisedCredentialsRiskConfiguration?: CompromisedCredentialsRiskConfigurationType;
  AccountTakeoverRiskConfiguration?: AccountTakeoverRiskConfigurationType;
  RiskExceptionConfiguration?: RiskExceptionConfigurationType;
}
export interface SetRiskConfigurationResponse {
  RiskConfiguration: RiskConfigurationType | undefined;
}
export interface SetUICustomizationRequest {
  UserPoolId: string | undefined;
  ClientId?: string;
  CSS?: string;
  ImageFile?: Uint8Array;
}
export interface SetUICustomizationResponse {
  UICustomization: UICustomizationType | undefined;
}
export interface SetUserMFAPreferenceRequest {
  SMSMfaSettings?: SMSMfaSettingsType;
  SoftwareTokenMfaSettings?: SoftwareTokenMfaSettingsType;
  AccessToken: string | undefined;
}
export interface SetUserMFAPreferenceResponse {}
export interface SetUserPoolMfaConfigRequest {
  UserPoolId: string | undefined;
  SmsMfaConfiguration?: SmsMfaConfigType;
  SoftwareTokenMfaConfiguration?: SoftwareTokenMfaConfigType;
  MfaConfiguration?: UserPoolMfaType;
}
export interface SetUserPoolMfaConfigResponse {
  SmsMfaConfiguration?: SmsMfaConfigType;
  SoftwareTokenMfaConfiguration?: SoftwareTokenMfaConfigType;
  MfaConfiguration?: UserPoolMfaType;
}
export interface SetUserSettingsRequest {
  AccessToken: string | undefined;
  MFAOptions: MFAOptionType[] | undefined;
}
export interface SetUserSettingsResponse {}
export interface SignUpRequest {
  ClientId: string | undefined;
  SecretHash?: string;
  Username: string | undefined;
  Password: string | undefined;
  UserAttributes?: AttributeType[];
  ValidationData?: AttributeType[];
  AnalyticsMetadata?: AnalyticsMetadataType;
  UserContextData?: UserContextDataType;
  ClientMetadata?: Record<string, string>;
}
export interface SignUpResponse {
  UserConfirmed: boolean | undefined;
  CodeDeliveryDetails?: CodeDeliveryDetailsType;
  UserSub: string | undefined;
}
export interface StartUserImportJobRequest {
  UserPoolId: string | undefined;
  JobId: string | undefined;
}
export interface StartUserImportJobResponse {
  UserImportJob?: UserImportJobType;
}
export interface StopUserImportJobRequest {
  UserPoolId: string | undefined;
  JobId: string | undefined;
}
export interface StopUserImportJobResponse {
  UserImportJob?: UserImportJobType;
}
export interface TagResourceRequest {
  ResourceArn: string | undefined;
  Tags: Record<string, string> | undefined;
}
export interface TagResourceResponse {}
export interface UntagResourceRequest {
  ResourceArn: string | undefined;
  TagKeys: string[] | undefined;
}
export interface UntagResourceResponse {}
export interface UpdateAuthEventFeedbackRequest {
  UserPoolId: string | undefined;
  Username: string | undefined;
  EventId: string | undefined;
  FeedbackToken: string | undefined;
  FeedbackValue: FeedbackValueType | undefined;
}
export interface UpdateAuthEventFeedbackResponse {}
export interface UpdateDeviceStatusRequest {
  AccessToken: string | undefined;
  DeviceKey: string | undefined;
  DeviceRememberedStatus?: DeviceRememberedStatusType;
}
export interface UpdateDeviceStatusResponse {}
export interface UpdateGroupRequest {
  GroupName: string | undefined;
  UserPoolId: string | undefined;
  Description?: string;
  RoleArn?: string;
  Precedence?: number;
}
export interface UpdateGroupResponse {
  Group?: GroupType;
}
export interface UpdateIdentityProviderRequest {
  UserPoolId: string | undefined;
  ProviderName: string | undefined;
  ProviderDetails?: Record<string, string>;
  AttributeMapping?: Record<string, string>;
  IdpIdentifiers?: string[];
}
export interface UpdateIdentityProviderResponse {
  IdentityProvider: IdentityProviderType | undefined;
}
export interface UpdateResourceServerRequest {
  UserPoolId: string | undefined;
  Identifier: string | undefined;
  Name: string | undefined;
  Scopes?: ResourceServerScopeType[];
}
export interface UpdateResourceServerResponse {
  ResourceServer: ResourceServerType | undefined;
}
export interface UpdateUserAttributesRequest {
  UserAttributes: AttributeType[] | undefined;
  AccessToken: string | undefined;
  ClientMetadata?: Record<string, string>;
}
export interface UpdateUserAttributesResponse {
  CodeDeliveryDetailsList?: CodeDeliveryDetailsType[];
}
export interface UpdateUserPoolRequest {
  UserPoolId: string | undefined;
  Policies?: UserPoolPolicyType;
  DeletionProtection?: DeletionProtectionType;
  LambdaConfig?: LambdaConfigType;
  AutoVerifiedAttributes?: VerifiedAttributeType[];
  SmsVerificationMessage?: string;
  EmailVerificationMessage?: string;
  EmailVerificationSubject?: string;
  VerificationMessageTemplate?: VerificationMessageTemplateType;
  SmsAuthenticationMessage?: string;
  UserAttributeUpdateSettings?: UserAttributeUpdateSettingsType;
  MfaConfiguration?: UserPoolMfaType;
  DeviceConfiguration?: DeviceConfigurationType;
  EmailConfiguration?: EmailConfigurationType;
  SmsConfiguration?: SmsConfigurationType;
  UserPoolTags?: Record<string, string>;
  AdminCreateUserConfig?: AdminCreateUserConfigType;
  UserPoolAddOns?: UserPoolAddOnsType;
  AccountRecoverySetting?: AccountRecoverySettingType;
}
export interface UpdateUserPoolResponse {}
export interface UpdateUserPoolClientRequest {
  UserPoolId: string | undefined;
  ClientId: string | undefined;
  ClientName?: string;
  RefreshTokenValidity?: number;
  AccessTokenValidity?: number;
  IdTokenValidity?: number;
  TokenValidityUnits?: TokenValidityUnitsType;
  ReadAttributes?: string[];
  WriteAttributes?: string[];
  ExplicitAuthFlows?: ExplicitAuthFlowsType[];
  SupportedIdentityProviders?: string[];
  CallbackURLs?: string[];
  LogoutURLs?: string[];
  DefaultRedirectURI?: string;
  AllowedOAuthFlows?: OAuthFlowType[];
  AllowedOAuthScopes?: string[];
  AllowedOAuthFlowsUserPoolClient?: boolean;
  AnalyticsConfiguration?: AnalyticsConfigurationType;
  PreventUserExistenceErrors?: PreventUserExistenceErrorTypes;
  EnableTokenRevocation?: boolean;
  EnablePropagateAdditionalUserContextData?: boolean;
  AuthSessionValidity?: number;
}
export interface UpdateUserPoolClientResponse {
  UserPoolClient?: UserPoolClientType;
}
export interface UpdateUserPoolDomainRequest {
  Domain: string | undefined;
  UserPoolId: string | undefined;
  CustomDomainConfig: CustomDomainConfigType | undefined;
}
export interface UpdateUserPoolDomainResponse {
  CloudFrontDomain?: string;
}
export declare class EnableSoftwareTokenMFAException extends __BaseException {
  readonly name: "EnableSoftwareTokenMFAException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      EnableSoftwareTokenMFAException,
      __BaseException
    >
  );
}
export interface VerifySoftwareTokenRequest {
  AccessToken?: string;
  Session?: string;
  UserCode: string | undefined;
  FriendlyDeviceName?: string;
}
export declare const VerifySoftwareTokenResponseType: {
  readonly ERROR: "ERROR";
  readonly SUCCESS: "SUCCESS";
};
export type VerifySoftwareTokenResponseType =
  (typeof VerifySoftwareTokenResponseType)[keyof typeof VerifySoftwareTokenResponseType];
export interface VerifySoftwareTokenResponse {
  Status?: VerifySoftwareTokenResponseType;
  Session?: string;
}
export interface VerifyUserAttributeRequest {
  AccessToken: string | undefined;
  AttributeName: string | undefined;
  Code: string | undefined;
}
export interface VerifyUserAttributeResponse {}
export declare const SetRiskConfigurationRequestFilterSensitiveLog: (
  obj: SetRiskConfigurationRequest
) => any;
export declare const SetRiskConfigurationResponseFilterSensitiveLog: (
  obj: SetRiskConfigurationResponse
) => any;
export declare const SetUICustomizationRequestFilterSensitiveLog: (
  obj: SetUICustomizationRequest
) => any;
export declare const SetUICustomizationResponseFilterSensitiveLog: (
  obj: SetUICustomizationResponse
) => any;
export declare const SetUserMFAPreferenceRequestFilterSensitiveLog: (
  obj: SetUserMFAPreferenceRequest
) => any;
export declare const SetUserSettingsRequestFilterSensitiveLog: (
  obj: SetUserSettingsRequest
) => any;
export declare const SignUpRequestFilterSensitiveLog: (
  obj: SignUpRequest
) => any;
export declare const UpdateAuthEventFeedbackRequestFilterSensitiveLog: (
  obj: UpdateAuthEventFeedbackRequest
) => any;
export declare const UpdateDeviceStatusRequestFilterSensitiveLog: (
  obj: UpdateDeviceStatusRequest
) => any;
export declare const UpdateUserAttributesRequestFilterSensitiveLog: (
  obj: UpdateUserAttributesRequest
) => any;
export declare const UpdateUserPoolClientRequestFilterSensitiveLog: (
  obj: UpdateUserPoolClientRequest
) => any;
export declare const UpdateUserPoolClientResponseFilterSensitiveLog: (
  obj: UpdateUserPoolClientResponse
) => any;
export declare const VerifySoftwareTokenRequestFilterSensitiveLog: (
  obj: VerifySoftwareTokenRequest
) => any;
export declare const VerifySoftwareTokenResponseFilterSensitiveLog: (
  obj: VerifySoftwareTokenResponse
) => any;
export declare const VerifyUserAttributeRequestFilterSensitiveLog: (
  obj: VerifyUserAttributeRequest
) => any;
