
const { executeQuery } = require("../../utils/utils");
const { User_Role_Table } = require("../../Database/Table_Names/TB_Name_Collection");

function Create_User_Role (role_name, permissions) {
    const sql = `INSERT INTO ${User_Role_Table}(role_name, permissions) VALUES(?, ?)`;
    const params = [role_name, permissions];

    return executeQuery(sql, params);
}

function Update_User_Role(id,role_name, permissions) {
    const sql = `UPDATE ${User_Role_Table} SET role_name = ?, permissions = ? WHERE id = ? AND is_deleted <> 1`;
    const params = [role_name, permissions, id];

    return executeQuery(sql, params);
}

function Get_All_Roles() {
    const sql = `SELECT  * FROM ${User_Role_Table} where is_deleted <> 1`;

    return executeQuery(sql, []);
}

function Get_Single_Role(id) {
    const sql = `SELECT * FROM  ${User_Role_Table} WHERE id = ? AND is_deleted <> 1`
    const params = [id];

    return executeQuery(sql, params);
}

function Delete_Role (id) {
    const sql = `DELETE FROM ${User_Role_Table} WHERE id = ? AND is_deleted <> 1`
    const params = [id];

    return executeQuery(sql, params);
}

module.exports = {Create_User_Role, Update_User_Role, Get_All_Roles, Get_Single_Role, Delete_Role};
