import React, { useState } from 'react'
import BasicForm from '@/views/ui-components/forms/FormControl/Basic'
import { Button, Input } from '@/components/ui'
import { useAppSelector } from '@/store'
import { HiOutlineUser } from 'react-icons/hi'
import { FiEdit } from 'react-icons/fi'

type jsonDataType = {
  id: number,
  key: string,
  value: string,
  toEdit: boolean,
}
const AWS_jsonData: jsonDataType[] = [
  {
    id: 1,
    key: "AWS Secret Key",
    value: "your_secret_key",
    // value:"",
    toEdit: false,
    // toEdit:true,
  },
  {
    id: 2,
    key: "AWS Access Key",
    value: "your_access_key",
    // value:"",
    toEdit: false,
    // toEdit:true,
  },
  {
    id: 3,
    key: "App Client Secret",
    value: "your_client_secret",
    // value:"",
    toEdit: false,
    // toEdit:true,
  },
  {
    id: 4,
    key: "APP Client ID",
    value: "your_client_id",
    // value:"",
    toEdit: false,
    // toEdit:true,
  },
  {
    id: 5,
    key: "User Pool ID",
    value: "your_user_pool_id",
    // value:"",
    toEdit: false,
    // toEdit:true,
  },
  {
    id: 6,
    key: "AWS Region",
    value: "your_aws_region_number",
    // value: "",
    toEdit: false,
    // toEdit: true,
  }
]


const ExternalApi = () => {
  const theme = useAppSelector((state) => state.theme)
  const [jsonData, setJsonData] = useState(AWS_jsonData)

  return (
    <>
      <div className={`${theme.mode == "dark" ? 'bg-[rgb(31,41,55)]' : 'bg-[rgb(255,255,255)]'} p-3 rounded-2xl px-10`} >
        <div className='mt-3 mb-10  flex items-center justify-between'>
          <h3 className=''><b>AWS API</b></h3>
        </div>

        <div>

          {
            jsonData.length > 0 && jsonData.map((item, index) => {
              return <div key={index} className='flex items-center mb-5'>
                <div className="text w-72">{item.key}</div>
                <div className=" flex-1">
                  <Input
                    placeholder={`Enter ${item.key}`}
                    value={item.value}
                    onChange={(e) => {
                      setJsonData((prev) => {
                        return prev.map((itemm) => itemm.id === item.id ? { ...itemm, value: e.target.value } : itemm)
                      })
                    }}
                    disabled={!item.toEdit}
                    suffix={
                      <>
                        {
                          (item.value && !item.toEdit) && <FiEdit onClick={() => {
                            setJsonData((prev) => {
                              return prev.map((obj) => obj.id == item.id ? { ...obj, toEdit: true } : obj)
                            })
                          }} className="text-lg cursor-pointer" />
                        }
                      </>
                    }
                  />
                </div>
              </div>
            })

          }

          <div className='text-center'>
            <Button
              className="mr-2 mb-2 font-bold text-lg"
              size="md" variant="solid"
              color={theme ? `${theme.themeColor}-${theme.primaryColorLevel}` : "blue-600"}
              disabled={!jsonData.some((item) => item.toEdit)}
            >
              Save
            </Button>
          </div>
        </div>
      </div>
    </>
  )
}

export default ExternalApi
