import { lazy } from 'react'
import type { Routes } from '@/@types/routes'
import { ADMIN, USER } from '@/constants/roles.constant'

const authRoute: Routes = [
    {
        key: 'signIn',
        path: `/sign-in`,
        component: lazy(() => import('@/views/auth/SignIn')),
        authority: [ADMIN, USER],
        meta: {
            layout: 'simple',
            pageContainerType: 'gutterless',
            footer: false,
        },
    },
    {
        key: 'signUp',
        path: `/sign-up`,
        component: lazy(() => import('@/views/auth/SignUp')),
        authority: [ADMIN, USER],
        meta: {
            layout: 'simple',
            pageContainerType: 'gutterless',
            footer: false,
        },
    },
    {
        key: 'forgotPassword',
        path: `/forgot-password`,
        component: lazy(() => import('@/views/auth/ForgotPassword')),
        authority: [ADMIN, USER],
        meta: {
            layout: 'simple',
            pageContainerType: 'gutterless',
            footer: false,
        },
    },
    {
        key: 'resetPassword',
        path: `/reset-password`,
        component: lazy(() => import('@/views/auth/ResetPassword')),
        authority: [ADMIN, USER],
        meta: {
            layout: 'simple',
            pageContainerType: 'gutterless',
            footer: false,
        },
    },
]

export default authRoute
